import {SoundIWithoutPreview} from "../../../../src/types/preset";

const SOUND_TYPES = [
    "Bounce",
    "Cubic",
    "Ease In",
    "Ease Out",
    "Easy Ease",
    "Linear",
    "Shake",
    "Swinging",
    "Wheel Ease In",
    "Wheel Ease Out",
    "Wheel Easy Ease",
    "Zoom Ease In 1",
    "Zoom Ease In 2",
    "Zoom Ease Out 1",
    "Zoom Ease Out 2",
    "Zoom Easy Ease 1",
    "Zoom Easy Ease 2",
    "Zoom Easy Ease 3",
    "Zoom Hit 1",
    "Zoom Hit 2",
    "Zoom Linear 1",
    "Zoom Linear 2",
    "Zoom Swinging 1",
    "Zoom Swinging 2",
]

export default function createSoundElement(
    categoryName: string,
    soundType: string = "Linear",
): SoundIWithoutPreview {

    return {
        name: categoryName,
        // path: `D:\\temp\\MotionBro\\${packFolderName}_by_Videolancer\\${categoryName} [${soundType}].wav`,
        path: `http://localhost:3000/ignore/preview/sound/sfx_pack/${categoryName}/${categoryName} [${soundType}].wav`,
        type: "wav"
    }
}


interface createSoundCategoryPropsI {
    categoryName: string
}

export function createSoundCategory({categoryName}: createSoundCategoryPropsI): SoundIWithoutPreview[] {

        return SOUND_TYPES.map(soundType => createSoundElement(categoryName, soundType))

}

